package djvideoad

import (
	"crypto/md5"
	"database/sql"

	//~ "djbannerad"
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djgetad_models"
	"djlogger"
	"djredis"
	"encoding/hex"
	"fmt"
	openrtb3 "openrtb/openrtb3"
	"path"
	"strconv"
	"strings"
	"time"

	openrtb "openrtb/openrtb2.5"
)

type Cadv struct {
	Clientid   int
	Clientname string
	Clientexp  sql.NullString
}

type Ccat struct {
	Cname string
}

var client_table = djconstants.TablePrefix + "clients"
var campaign_table = djconstants.TablePrefix + "campaigns"
var sitCat_table = "djax_site_categories"

// Function to get video ad
func GetVideoads(vidChannel chan []djgetad.GetAd, video *openrtb3.Video, req_details map[string]interface{}, pmp int8, deals []openrtb3.Deal) {
	videoads, err := djgetad_models.VideoSearch(video.Mime, video.Ctype, video.Linear, video.Mindur, video.Maxdur, video.Minbitr, video.Maxbitr, video.MaxExtended, req_details["dsp_id"].(int), pmp, deals, nil)
	if err != nil {
		djlogger.Log.Println(err)
	}
	vidChannel <- videoads
}

// Function to get video ad 2.5
func GetVideoads25(vidChannel chan []djgetad.GetAd, video *openrtb.Video, req_details map[string]interface{}, pmp int8, deals []openrtb.Deal) {
	videoads, err := djgetad_models.VideoSearch(video.Mimes, video.Protocols, video.Linearity, video.MinDuration, video.MaxDuration, video.MinBitrate, video.MaxBitrate, video.MaxExtended, req_details["dsp_id"].(int), pmp, nil, deals)
	if err != nil {
		djlogger.Log.Println(err)
		fmt.Println("Error", err)
	}
	vidChannel <- videoads
}

// Function to get vast XML
func GetVastXML(videoad djgetad.GetAd, video *openrtb3.Video, video25 *openrtb.Video, req_details map[string]interface{}, resID string, cookieid string, redisClient *djredis.RedisClient) (string, int) {

	vA := &Cadv{}
	var (
		protocol, bannerid, vastxml, fc_path, impression, logurl, nurl, rubiconDmpurl, pricingtype, error_code, adVerifications, viewableImpression, iabcategory, url_1, url_2, trackingUrl, Is_conditionalad, adservingid, advertiser, expiretime, clientname, companionads string
		clientid, width, height, vskip, vAttr, vSkipMin, vSkipAfter                                                                                                                                                                                                          int
		vapi                                                                                                                                                                                                                                                                 []int
		clientexp                                                                                                                                                                                                                                                            sql.NullString
	)
	if video != nil {
		width = video.W
		height = video.H
		vskip = video.Skip
		vSkipMin = video25.SkipMin
		vSkipAfter = video.Skipafter
		vapi = video.Api
		/*Companion Ads*/
		if len(video.Comp) > 0 {
			//~ companionads = `<Creative><CompanionAds>`
			//~ for _, v := range video.Comp {
			//~ if v.Display.Displayfmt != nil {
			//~ banChannel := make(chan []djgetad.GetAd)
			//~ go djbannerad.GetBannerads(banChannel, v.Display.Mimes, v.Display.Displayfmt, req_details, 0, nil, redisClient)
			//~ banads := <-banChannel
			//~ if len(banads) > 0 {
			//~ creativeType := strings.Split(banads[0].Filename, ".")
			//~ companionads += `
			//~ <Companion width="` + strconv.Itoa(banads[0].Width) + `" height="` + strconv.Itoa(banads[0].Height) + `">
			//~ <StaticResource creativeType="image/` + creativeType[1] + `">` + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + banads[0].Filename + `</StaticResource>
			//~ <CompanionClickThrough>` + djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + strconv.Itoa(banads[0].Ad_id) + "&zoneid=0&oadest=" + banads[0].Url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + strconv.Itoa(banads[0].Placement_id) + `</CompanionClickThrough>
			//~ </Companion>`
			//~ }
			//~ }
			//~ }
			//~ companionads += `</CompanionAds></Creative>`
		}
		/*Companion Ads*/
	} else if video25 != nil {
		width = video25.W
		height = video25.H
		vskip = video25.Skip
		vSkipMin = video25.SkipMin
		vSkipAfter = video25.SkipAfter
		vapi = video25.Api

		//~ fmt.Println("ddddddddddddd")

		//~ /*Companion Ads*/
		//~ if video25.CompanionAd != nil {
		//~ fmt.Println("ddddddddddddd")

		//~ companionads = `<Creative><CompanionAds>`

		//~ for _, v := range video25.CompanionAd {
		//~ banChannel := make(chan []djgetad.GetAd)
		//~ go djbannerad.GetBannerads25(banChannel, &v, req_details, 0, nil, redisClient)
		//~ banads := <-banChannel
		//~ if len(banads) > 0 {
		//~ creativeType := strings.Split(banads[0].Filename, ".")
		//~ companionads += `
		//~ <Companion width="` + strconv.Itoa(banads[0].Width) + `" height="` + strconv.Itoa(banads[0].Height) + `">
		//~ <StaticResource creativeType="image/` + creativeType[1] + `">` + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + banads[0].Filename + `</StaticResource>
		//~ <CompanionClickThrough>` + djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + strconv.Itoa(banads[0].Ad_id) + "&zoneid=0&oadest=" + banads[0].Url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + strconv.Itoa(banads[0].Placement_id) + `</CompanionClickThrough>
		//~ </Companion>`
		//~ }
		//~ }
		//~ fmt.Println("ddddddddddddd")

		//~ companionads += `</CompanionAds></Creative>`
		//~ }
		//~ fmt.Println("ddddddddddddd")

		//~ /*Companion Ads*/
	}

	if height == 0 {

		height = 640
	}

	if width == 0 {

		width = 480
	}

	bannerid = strconv.Itoa(videoad.Ad_id)
	protocol = djconstants.ReviveProtocol
	logurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + bannerid + "&campaignid=" + strconv.Itoa(videoad.Placement_id) + "&zoneid=0&bidid=" + resID
	nurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE:BF}"
	rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?cookieid=" + cookieid + "&dspid=" + strconv.Itoa(req_details["dsp_id"].(int))
	fc_path = protocol + djconstants.ReviveRoot + "/fc.php"
	trackingUrl = fc_path + "?script=rmvideoAds:rmvastEvent&bannerid=" + bannerid + "&zoneid=0"
	adservingid = req_details["Host"].(string) + djextrafunc.RandToken(5) + bannerid
	hasher := md5.New()
	hasher.Write([]byte(adservingid))
	adservingid = hex.EncodeToString(hasher.Sum(nil))
	/*Advertiser*/
	err := redisClient.GetKey("djvAdv"+strconv.Itoa(videoad.Placement_id), vA)
	if err != nil {
		djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
	}
	if vA != nil && err == nil {
		clientid = vA.Clientid
		clientname = vA.Clientname
		clientexp = vA.Clientexp
	} else {
		djdb.DbQueryRow("select cl.clientid as clientid,cl.clientname as name,c.expire_time as expire_time from "+client_table+" as cl,"+campaign_table+" as c where c.clientid=cl.clientid and c.campaignid=?", videoad.Placement_id).Scan(&clientid, &clientname, &clientexp)

		err := redisClient.SetKey("djvAdv"+strconv.Itoa(videoad.Placement_id), &Cadv{Clientid: clientid, Clientname: clientname, Clientexp: clientexp}, time.Minute*djconstants.RedisExpInMin)
		if err != nil {
			djlogger.Log.Println("Error in setting redis key: ", err.Error())
		}
	}
	advertiser = `<Advertiser id="` + strconv.Itoa(clientid) + `">` + clientname + `</Advertiser>`
	/*Advertiser*/
	/*Expires*/
	if clientexp.String != "" {
		expiretime = `<Expires>` + fmt.Sprint(clientexp) + `</Expires>`
	}
	/*Expires*/
	/*Pricingtype*/
	if videoad.Revenue_type == 1 {
		pricingtype = "CPM"
	} else if videoad.Revenue_type == 2 {
		pricingtype = "CPC"
	} else if videoad.Revenue_type == 3 {
		pricingtype = "CPA"
	}
	/*Pricingtype*/
	/*Is_conditionalad*/
	if videoad.Is_conditionalad == 1 {
		Is_conditionalad = "true"
	} else {
		Is_conditionalad = "false"
	}
	/*Is_conditionalad*/
	/*Impression*/
	impression = `<Impression><![CDATA[` + nurl + `]]></Impression>`
	impression += `<Impression><![CDATA[` + logurl + `]]></Impression>`
	impression += `<Impression><![CDATA[` + rubiconDmpurl + `]]></Impression>`
	if req_details["dmp_pixel"].(string) != "" {
		impression += `<Impression><![CDATA[` + req_details["dmp_pixel"].(string) + `]]></Impression>`
	}
	if videoad.Vast_thirdparty_impression != "" {
		impression += `<Impression><![CDATA[` + videoad.Vast_thirdparty_impression + `]]></Impression>`
	}
	/*Impression*/
	/*Error code Add*/
	error_code = `<Error><![CDATA[` + protocol + djconstants.ReviveDelivery + `/errorcode.php?zoneid=0&errorcode=[ERRORCODE]]]></Error>`
	/*Errorcode add*/
	/*Adverification for Vast4*/
	if videoad.Vast4_verificationurl1.String != "" || videoad.Vast4_verificationurl2.String != "" {
		if videoad.Vast4_verificationurl1.String == "1" {
			url_1 = `<Verification>
						<JavaScriptResource>
						<![CDATA[` + videoad.Vast4_verificationurl1.String + `]]>
						</JavaScriptResource>
					</Verification>`
		} else if videoad.Vast4_verificationurl1.String == "2" {
			url_1 = `<Verification>
						<FlashResource>
						<![CDATA[` + videoad.Vast4_verificationurl1.String + `]]>
						</FlashResource>
					</Verification>`
		}
		if videoad.Vast4_verificationurl2.String == "1" {
			url_2 = `<Verification>
							<JavaScriptResource>
							<![CDATA[` + videoad.Vast4_verificationurl2.String + `]]>
							</JavaScriptResource>
						</Verification>`
		} else if videoad.Vast4_verificationurl2.String == "2" {
			url_2 = `<Verification>
							<FlashResource>
							<![CDATA[` + videoad.Vast4_verificationurl2.String + `]]>
							</FlashResource>
						</Verification>`
		}
		if url_1 != "" || url_2 != "" {
			adVerifications = `<AdVerifications>
								` + url_1 + `
								` + url_2 + `
							</AdVerifications>`
		}
	}
	/*Adverification for Vast4*/
	/*Viewable Impression*/
	viewableImpression = `<ViewableImpression id="` + strconv.Itoa(djextrafunc.RandNumber(10)) + `">
								<Viewable><![CDATA[` + trackingUrl + `&event=viewable]]></Viewable>
								<NotViewable><![CDATA[` + trackingUrl + `&event=notviewable]]></NotViewable>
								<ViewUndetermined><![CDATA[` + trackingUrl + `&event=viewundetermined]]></ViewUndetermined>
							</ViewableImpression>`
	/*Viewable Impression*/
	/*IAB Category in vast response*/
	if videoad.Iabcategory.String != "" {
		category := strings.Split(videoad.Iabcategory.String, ",")
		for _, v := range category {
			var cname string
			vC := &Ccat{}
			err := redisClient.GetKey("djvCat"+v, vC)
			if err != nil {
				djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				cname = vC.Cname
			} else {
				djdb.DbQueryRow("SELECT category_name FROM `" + sitCat_table + "` where value = '" + v + "'").Scan(&cname)
				err := redisClient.SetKey("djvCat"+v, &Ccat{Cname: cname}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
			iabcategory += `<Category authority='http://www.iabtechlab.com/categoryauthority'><![CDATA[` + cname + `]]></Category>`
		}
	}

	/*IAB Category in vast response*/
	/*Inline & Overlay Ad XML Response*/
	if videoad.Width == -3 && videoad.Height == -3 {
		var api, iprog, clickurl, skip, skip_progress_duration, mediafile, mediafile1, mediafile2, videoClicksVast, videoClickstrackVast, videocustomClicksVast, closedcaption, closedcaption2, closedcaption3, type1, type2, type3, lang, lang1, lang2, interactivemediafile, Mezzaninefile, maxbitrate, minbitrate, icontype1, resource, icon, pricing, adType string
		adservingid = req_details["Host"].(string) + djextrafunc.RandToken(5) + bannerid
		hasher := md5.New()
		hasher.Write([]byte(adservingid))
		adservingid = hex.EncodeToString(hasher.Sum(nil))
		api = djextrafunc.ArrayToString(vapi, ",")
		iprog = ""
		/*Icontype*/
		k := strings.Split(path.Base(videoad.Vast_icon_filename.String), ".")
		icontype1 = string(k[1])
		if icontype1 == "jpg" || icontype1 == "jpeg" {
			icontype1 = "image/jpeg"
		} else if icontype1 == "png" {
			icontype1 = "image/png"
		} else if icontype1 == "gif" {
			icontype1 = "Image/gif"
		} else if icontype1 == "htm" {
			icontype1 = "Image/htm"
		} else {
			icontype1 = ""
		}
		/*Icontype*/
		/*Clickurl*/
		if videoad.Vast_video_clickthrough_url.String != "" {
			clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + bannerid + "&zoneid=0&oadest=" + videoad.Vast_video_clickthrough_url.String + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + strconv.Itoa(videoad.Placement_id)
		}
		/*Clickurl*/
		/*Skip*/
		if vskip == 0 {
			if videoad.Vast_video_skip_duration.String != "" {
				skip = `skipoffset="` + videoad.Vast_video_skip_duration.String + `"`
				vAttr = 1
			}
		} else if vskip == 1 {
			if vSkipMin != 0 && vSkipAfter != 0 {
				if int(videoad.Vast_video_duration.Int64) > vSkipMin {
					skip = `skipoffset="` + djextrafunc.SecondsToTime(vSkipAfter) + `"`
				}
			} else if vSkipMin == 0 && vSkipAfter != 0 {
				skip = `skipoffset="` + djextrafunc.SecondsToTime(vSkipAfter) + `"`
			}
		}
		/*Skip*/
		/*Skip Progress*/
		if videoad.Vast_video_skip_progress_duration.String != "" {
			skip_progress_duration = `offset="` + videoad.Vast_video_skip_progress_duration.String + `"`
		} else {
			skip_progress_duration = ""
		}
		/*Skip Progress*/
		/*Vast_video_type*/
		if videoad.Vast_video_type.String == "video/x-mp4" {
			videoad.Vast_video_type.String = "video/mp4"
		}
		/*Vast_video_type*/
		/*Min Max Bitrate*/
		if videoad.Vast4_max_bitrate.Int64 != 0 {
			maxbitrate = `"maxBitrate="` + `"` + strconv.Itoa(int(videoad.Vast4_max_bitrate.Int64)) + `"`
		}
		if videoad.Vast4_min_bitrate.Int64 != 0 {
			minbitrate = `"minBitrate="` + `"` + strconv.Itoa(int(videoad.Vast4_min_bitrate.Int64)) + `"`
		}
		/*Min Max Bitrate*/
		/*Ad_type*/
		if videoad.Ad_type.Int64 == 1 {
			adType = "audio"
		} else {
			adType = "video"
		}
		/*Ad_type*/
		/*Pricing*/
		pricing = `<Pricing model="` + pricingtype + `" currency="USD"><![CDATA[` + videoad.Revenue + `]]></Pricing>`
		/*Pricing*/
		/*<Icon>*/
		if videoad.Vast_icon_filename.String != "" {

			if icontype1 == "image/jpeg" {
				resource = `<StaticResource creativeType="` + icontype1 + `"><![CDATA[` + videoad.Vast_icon_filename.String + `]]></StaticResource>`
			} else {
				resource = `<HTMLResource><![CDATA[` + videoad.Vast_icon_filename.String + `]]></HTMLResource>`
			}
			icon = `<Icons>
							<Icon program="` + iprog + `" height= "` + strconv.Itoa(int(videoad.Vast_icon_height)) + `" width= "` + strconv.Itoa(int(videoad.Vast_icon_width)) + `" xPosition= "` + strconv.Itoa(int(videoad.Vast_icon_xposition.Int64)) + `" yPosition= "` + strconv.Itoa(int(videoad.Vast_icon_yposition.Int64)) + `" apiFramework="` + api + `" offset= "` + videoad.Vast_icon_offset.String + `" duration= "` + videoad.Vast_icon_duration.String + `">
							` + resource + `
								<IconClicks>
									<IconClickThrough><![CDATA[` + trackingUrl + `&event=iconclick]]> </IconClickThrough>
									<IconClickTracking><![CDATA[` + trackingUrl + `&event=icontrack]]></IconClickTracking>
								</IconClicks>
								<IconViewTracking>
								<![CDATA[` + trackingUrl + `&event=iconimpression]]>
								</IconViewTracking>
							</Icon>
						</Icons>`
		}
		/*<Icon>*/
		/*<Clickthrough_url>*/
		if videoad.Vast_video_clickthrough_url.String != "" {
			if videoad.Vast_thirdparty_clicktracking.String != "" {
				videoClickstrackVast = `<ClickTracking><![CDATA[` + videoad.Vast_thirdparty_clicktracking.String + `]]></ClickTracking>`
			}
			if videoad.Vast_thirdparty_clickcustom.String != "" {
				videocustomClicksVast = `<CustomClick><![CDATA[` + videoad.Vast_thirdparty_clickcustom.String + `]]></CustomClick >`
			}
			videoClicksVast = `<VideoClicks>
									<ClickThrough><![CDATA[` + clickurl + `]]></ClickThrough> ` + videoClickstrackVast + videocustomClicksVast + `
								</VideoClicks>`
		}
		/*<Clickthrough_url>*/
		/*<InteractiveCreativeFile>*/
		if videoad.Interactive_mediafile.String != "" {
			interactivemediafile = `<InteractiveCreativeFile><![CDATA[` + videoad.Interactive_mediafile.String + `]]></InteractiveCreativeFile>`
		}
		/*<InteractiveCreativeFile>*/
		/*<Mezzanine>*/
		if videoad.Is_mezzininefile.Int64 == 1 {
			if videoad.Is_mezzininefile.Int64 == 1 && videoad.Internal_file.String != "" {
				Videofilepath := protocol + djconstants.ReviveAdmin + "/assets/transcoded_video/" + videoad.Internal_file.String
				Mezzaninefile = `<Mezzanine><![CDATA[` + Videofilepath + `]]></Mezzanine>`
			} else if videoad.Is_mezzininefile.Int64 == 2 {
				Mezzaninefile = `<Mezzanine><![CDATA[` + videoad.Url_file.String + `]]></Mezzanine>`
			}
		}
		/*<Mezzanine>*/
		/*CLosed Captions*/
		if videoad.Vast_4_1_type_file.String == "1" || videoad.Vast_4_1_type_file_1.String == "1" || videoad.Vast_4_1_type_file_2.String == "1" {
			type1 = "text/srt"
		} else if videoad.Vast_4_1_type_file.String == "2" || videoad.Vast_4_1_type_file_1.String == "2" || videoad.Vast_4_1_type_file_2.String == "2" {
			type2 = "text/vtt"
		} else if videoad.Vast_4_1_type_file.String == "3" || videoad.Vast_4_1_type_file_1.String == "3" || videoad.Vast_4_1_type_file_2.String == "3" {
			type3 = "application/ttml+xml"
		}
		if videoad.Vast_4_1_language.String == "1" || videoad.Vast_4_1_language_1.String == "1" || videoad.Vast_4_1_language_2.String == "1" {
			lang = "en"
		} else if videoad.Vast_4_1_language.String == "2" || videoad.Vast_4_1_language_1.String == "2" || videoad.Vast_4_1_language_2.String == "2" {
			lang1 = "zh-TW"
		} else if videoad.Vast_4_1_language.String == "3" || videoad.Vast_4_1_language_1.String == "3" || videoad.Vast_4_1_language_2.String == "3" {
			lang2 = "zh-CH"
		}
		if videoad.Vast_4_1_url.String != "" {
			if videoad.Vast_4_1_url.String != "" {
				closedcaption2 = `<ClosedCaptionFile type='` + type2 + `' language='` + lang1 + `'><![CDATA[` + videoad.Vast_4_1_url.String + `]]></ClosedCaptionFile>`
			}
			if videoad.Vast_4_1_url_2.String != "" {
				closedcaption3 = `<ClosedCaptionFile type='` + type3 + `' language='` + lang2 + `'><![CDATA[` + videoad.Vast_4_1_url_2.String + `]]></ClosedCaptionFile>`
			}
			closedcaption = `<ClosedCaptionFiles>
									<ClosedCaptionFile type='` + type1 + `' language='` + lang + `'><![CDATA[` + videoad.Vast_4_1_url.String + `]]></ClosedCaptionFile>` + closedcaption2 + closedcaption3 + `
								</ClosedCaptionFiles>`
		}
		/*CLosed Captions*/
		/*Mediafile*/

		if videoad.Vid_upload_type.String == "Internal" {

			videoad.Vast_video_outgoing_filename.String = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + videoad.Vast_video_outgoing_filename.String
		}
		mediafile = `<MediaFile delivery="` + videoad.Vast_video_delivery.String + `" bitrate="` + videoad.Vast_video_bitrate.String + `" width="` + strconv.Itoa(width) + `" height="` + strconv.Itoa(height) + `" ` + maxbitrate + ` ` + minbitrate + ` type="` + videoad.Vast_video_type.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[` + videoad.Vast_video_outgoing_filename.String + `]]></MediaFile>`
		if videoad.Vast_video_outgoing_filename1.String != "" {
			mediafile1 = `<MediaFile delivery="` + videoad.Vast_video_delivery.String + `" bitrate="` + videoad.Vast_video_bitrate_1.String + `" width="` + strconv.Itoa(width) + `" height="` + strconv.Itoa(height) + `" ` + maxbitrate + ` ` + minbitrate + ` type="` + videoad.Vast_video_type_1.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[` + videoad.Vast_video_outgoing_filename1.String + `]]></MediaFile>`
		}
		if videoad.Vast_video_outgoing_filename2.String != "" {
			mediafile2 = `<MediaFile delivery="` + videoad.Vast_video_delivery.String + `" bitrate="` + videoad.Vast_video_bitrate_2.String + `" width="` + strconv.Itoa(width) + `" height="` + strconv.Itoa(height) + `" ` + maxbitrate + ` ` + minbitrate + ` type="` + videoad.Vast_video_type_2.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[` + videoad.Vast_video_outgoing_filename2.String + `]]></MediaFile>`
		}

		videoadGet_third_internal_type := int(videoad.Get_third_internal_type.Int64)

		/*Mediafile*/
		if videoad.Vast_type == 1 {
			if videoadGet_third_internal_type == 1 {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<InLine>
											<AdSystem>
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											<AdTitle>
											<![CDATA[` + videoad.Name + `]]>
											</AdTitle>
											` + impression + `
											<Creatives>
												<Creative>
													<Linear>
														<Duration>` + djextrafunc.SecondsToTime(int(videoad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
																]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
																]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
																]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
																]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
																]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
																]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
																]]>
															</Tracking>
															<Tracking event="fullscreen">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=fullscreen
																]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
																]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
																]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `zoneid=0&event=resume
																]]>
															</Tracking>
														</TrackingEvents>
														<VideoClicks>
															<ClickThrough>
															<![CDATA[` + clickurl + `]]>
															</ClickThrough>
														</VideoClicks>
														<MediaFiles>
															` + mediafile + `
														</MediaFiles>
													</Linear>
												</Creative>																
												` + companionads + `													
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<Wrapper>
											<AdSystem>
											<![CDATA[` + djconstants.AppName + `]]></AdSystem>
											<AdTitle>
											<![CDATA[` + videoad.Name + `]]>
											</AdTitle>
											` + impression + `
											<VASTAdTagURI><![CDATA[` + strings.Replace(videoad.Vast_wrapper_url, "&", "&amp;", -1) + `]]></VASTAdTagURI>
											<Creatives>
												<Creative>
													<Linear>
														<Duration>` + djextrafunc.SecondsToTime(int(videoad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=` + bannerid + `&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="fullscreen">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=fullscreen
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
														</TrackingEvents>
														<VideoClicks>
															<ClickThrough>
															<![CDATA[` + clickurl + `]]>
															</ClickThrough>
														</VideoClicks>
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		} else if videoad.Vast_type == 2 {
			if videoadGet_third_internal_type == 1 {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<InLine>
											<AdSystem>
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											<AdTitle>
											<![CDATA[` + videoad.Name + `]]>
											</AdTitle>
											<Pricing>
												<model>
												<![CDATA[` + pricingtype + `]]>
												</model>
												<currency>
												<![CDATA[USD]]>
												</currency>
											</Pricing>
											` + impression + `
											<Creatives>
												<Creative>
													<Linear ` + skip + `>
														<Duration>` + djextrafunc.SecondsToTime(int(videoad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
																]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
																]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
																]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
																]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
																]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
																]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
																]]>
															</Tracking>
															<Tracking event="fullscreen">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=fullscreen
																]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
																]]>
															</Tracking>
															<Tracking event="closeLinear">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=closeLinear
																]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
																]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
																]]>
															</Tracking>
															<Tracking event="progress" ` + skip_progress_duration + `>
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
																]]>
															</Tracking>
															<Tracking event="exitFullscreen">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=exitfullscreen
																]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
																]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `zoneid=0&event=resume
																]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
														<MediaFiles>
															` + mediafile + `
														</MediaFiles>
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<Wrapper>
											<AdSystem>
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											<AdTitle>
											<![CDATA[` + videoad.Name + `]]>
											</AdTitle>
											<Pricing>
												<model>
												<![CDATA[` + pricingtype + `]]>
												</model>
												<currency>
												<![CDATA[USD]]>
												</currency>
											</Pricing>
											` + impression + `
											<VASTAdTagURI>
											<![CDATA[` + strings.Replace(videoad.Vast_wrapper_url, "&", "&amp;", -1) + `]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative>
													<Linear>
														<Duration>` + djextrafunc.SecondsToTime(int(videoad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="fullscreen">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=fullscreen
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
															]]>
															</Tracking>
															<Tracking event="closeLinear">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=closeLinear
															]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
															]]>
															</Tracking>
															<Tracking event="progress">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
															]]>
															</Tracking>
															<Tracking event="exitFullscreen">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=exitfullscreen
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		} else if videoad.Vast_type == 3 {
			if videoadGet_third_internal_type == 1 {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `" conditionalAd="` + Is_conditionalad + `">
										<InLine>
											<AdSystem version="4.0">
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											` + error_code + `
											<AdTitle>
											<![CDATA[` + videoad.Name + `]]>
											</AdTitle>
											` + adVerifications + `
											` + viewableImpression + `
											` + iabcategory + `
											` + pricing + `
											` + impression + `
											<Creatives>
												<Creative>
													<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
													<Linear ` + skip + `>
														<Duration>` + djextrafunc.SecondsToTime(int(videoad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
															]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
															]]>
															</Tracking>
															<Tracking event="progress" ` + skip_progress_duration + `>
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
															<Tracking event="timeSpentViewing">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=timeSpentViewing
															]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
															]]>
															</Tracking>
															<Tracking event="playerExpand">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerExpand
															]]>
															</Tracking>
															<Tracking event="playerCollapse">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerCollapse
															]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
														<MediaFiles>
															` + mediafile + `
															` + mediafile1 + `
															` + mediafile2 + `
															` + interactivemediafile + `
															` + Mezzaninefile + `
														</MediaFiles>
														` + icon + `
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `" conditionalAd="` + Is_conditionalad + `">
										<Wrapper fallbackOnNoAd="` + strconv.Itoa(videoad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(videoad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(videoad.Vast_wrapper_followadditional) + `">
											<AdSystem version="4.0">
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											` + error_code + `
											` + viewableImpression + `
											` + pricing + `
											` + impression + `
											<VASTAdTagURI>
											<![CDATA[` + strings.Replace(videoad.Vast_wrapper_url, "&", "&amp;", -1) + `]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative>
													<Linear>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
															]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
															]]>
															</Tracking>
															<Tracking event="progress">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
															<Tracking event="timeSpentViewing">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=timeSpentViewing
															]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
															]]>
															</Tracking>
															<Tracking event="playerExpand">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerExpand
															]]>
															</Tracking>
															<Tracking event="playerCollapse">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerCollapse
															]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
														` + icon + `
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		} else {
			if videoadGet_third_internal_type == 1 {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `"  adType="` + adType + `">
										<InLine>
											<AdSystem version="4.1">
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											<AdServingId>` + adservingid + `</AdServingId>
											` + advertiser + `
											<Description>` + videoad.Name + `</Description>
											` + expiretime + `
											` + error_code + `
											<AdTitle>
											<![CDATA[` + videoad.Name + `]]>
											</AdTitle>
											` + adVerifications + `
											` + viewableImpression + `
											` + iabcategory + `
											` + pricing + `
											` + impression + `
											<Creatives>
												<Creative>
													<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
													<Linear ` + skip + `>
														<Duration>` + djextrafunc.SecondsToTime(int(videoad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
															]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
															]]>
															</Tracking>
															<Tracking event="progress" ` + skip_progress_duration + `>
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
															<Tracking event="timeSpentViewing">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=timeSpentViewing
															]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
															]]>
															</Tracking>
															<Tracking event="playerExpand">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerExpand
															]]>
															</Tracking>
															<Tracking event="playerCollapse">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerCollapse
															]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
														<MediaFiles>
															` + closedcaption + `
															` + mediafile + `
															` + mediafile1 + `
															` + mediafile2 + `
															` + interactivemediafile + `
															` + Mezzaninefile + `
														</MediaFiles>
														` + icon + `
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `" conditionalAd="` + Is_conditionalad + `">
										<Wrapper fallbackOnNoAd="` + strconv.Itoa(videoad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(videoad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(videoad.Vast_wrapper_followadditional) + `">
											<AdSystem version="4.1">
											<![CDATA[` + djconstants.AppName + `]]>
											</AdSystem>
											<AdServingId>` + adservingid + `</AdServingId>
											` + advertiser + `
											<Description>` + videoad.Name + `</Description>
											` + expiretime + `
											` + viewableImpression + `
											` + pricing + `
											` + impression + `
											<VASTAdTagURI>
											<![CDATA[` + strings.Replace(videoad.Vast_wrapper_url, "&", "&amp;", -1) + `]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative>
													<Linear>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
															]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
															]]>
															</Tracking>
															<Tracking event="progress">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
															<Tracking event="timeSpentViewing">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=timeSpentViewing
															]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
															]]>
															</Tracking>
															<Tracking event="playerExpand">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerExpand
															]]>
															</Tracking>
															<Tracking event="playerCollapse">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerCollapse
															]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
														` + icon + `
													</Linear>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		}
	} else if videoad.Width == -2 && videoad.Height == -2 {
		var creativeType, oclickurl, nonLinearClickThrough, nonLinearClickTracking, creativeTypeAttribute, expand_width, expand_height, expand_duration, nonLinear, vpaid_swf, resourceType, elementName, code string
		creativeType = videoad.Vast_creative_type.String
		if videoad.Vast_overlay_format.String == "image_overlay" {
			if creativeType == "" {
				s := videoad.Filename
				creativeType = s[len(s)-3:]
				if creativeType == "peg" {
					creativeType = "jpeg"
				}
			}
			if creativeType == "jpeg" {
				creativeType = "jpg"
			}
			creativeType = "image/" + creativeType
			code = protocol + djconstants.ReviveImages + "/" + videoad.Filename
			resourceType = "static"
			elementName = "StaticResource"
		}
		if videoad.Url != "" {
			oclickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + bannerid + "&zoneid=0&oadest=" + videoad.Url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + strconv.Itoa(videoad.Placement_id)
		}
		if oclickurl != "" {
			nonLinearClickThrough = `<NonLinearClickThrough>
											<![CDATA[` + oclickurl + `]]>
										</NonLinearClickThrough>`
		}
		if videoad.Vast_thirdparty_clicktracking.String != "" {
			nonLinearClickTracking = `<NonLinearClickTracking>
											<![CDATA[` + videoad.Vast_thirdparty_clicktracking.String + `]]>
										</NonLinearClickTracking>`
		}
		if creativeType != "" {
			creativeType = strings.ToLower(creativeType)
			creativeTypeAttribute = `creativeType="` + creativeType + `"`
		}
		if videoad.Vast_overlay_expanded_width.Int64 != 0 {
			expand_width = `expandedWidth="` + strconv.Itoa(int(videoad.Vast_overlay_expanded_width.Int64)) + `"`
		}
		if videoad.Vast_overlay_expanded_height.Int64 != 0 {
			expand_height = `expandedHeight="` + strconv.Itoa(int(videoad.Vast_overlay_expanded_height.Int64)) + `"`
		}
		if videoad.Vast_overlay_expandedminduration.String != "" {
			expand_duration = `minSuggestedDuration="` + videoad.Vast_overlay_expandedminduration.String + `"`
		}
		/*nonLinear*/
		if resourceType == "static" {
			nonLinear = `<NonLinear id="overlay" width="` + strconv.Itoa(int(videoad.Vast_overlay_width.Int64)) + `" height="` + strconv.Itoa(int(videoad.Vast_overlay_height.Int64)) + `" maintainAspectRatio="true" ` + vpaid_swf + ` scalable="true" ` + expand_duration + ` ` + expand_width + ` ` + expand_height + `><` + elementName + ` ` + creativeTypeAttribute + `>
								<![CDATA[` + code + `]]></` + elementName + `>
								` + nonLinearClickThrough + `
								` + nonLinearClickTracking + `
							</NonLinear>`
		} else {
			nonLinear = `<NonLinear id="overlay">
								` + nonLinearClickThrough + `
								` + nonLinearClickTracking + `
							</NonLinear>`
		}
		/*nonLinear*/
		if videoad.Vast_type == 1 {
			if videoad.Vast_overlay_format.String == "image_overlay" {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<InLine>
											<AdSystem>
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											<AdTitle>
												<![CDATA[ ` + videoad.Name + ` ]]>
											</AdTitle>
											` + impression + `
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
															]]>
															</Tracking>
															<Tracking event="expand">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
															]]>
															</Tracking>
															<Tracking event="collapse">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
															]]>
															</Tracking>
															<Tracking event="acceptInvitation">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitation
															]]>
															</Tracking>
															<Tracking event="close">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=close
															]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<Wrapper>
											<AdSystem>
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											<AdTitle>
												<![CDATA[ ` + videoad.Name + ` ]]>
											</AdTitle>
											` + impression + `
											<VASTAdTagURI>
												<![CDATA[ ` + strings.Replace(videoad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
															]]>
															</Tracking>
															<Tracking event="expand">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
															]]>
															</Tracking>
															<Tracking event="collapse">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
															]]>
															</Tracking>
															<Tracking event="acceptInvitation">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitation
															]]>
															</Tracking>
															<Tracking event="close">
															<![CDATA[
																` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=close
															]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		} else if videoad.Vast_type == 2 {
			if videoad.Vast_overlay_format.String == "image_overlay" {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<InLine>
											<AdSystem>
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											<AdTitle>
												<![CDATA[ ` + videoad.Name + ` ]]>
											</AdTitle>
											<Pricing>
												<model>
													<![CDATA[ ` + pricingtype + ` ]]>
												</model>
												<currency>
													<![CDATA[ USD ]]>
												</currency>
											</Pricing>
											` + impression + `											
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
																]]>
															</Tracking>
															<Tracking event="expand">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
																]]>
															</Tracking>
															<Tracking event="collapse">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
																]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<Wrapper>
											<AdSystem>
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											<AdTitle>
												<![CDATA[ ` + videoad.Name + ` ]]>
											</AdTitle>
											<Pricing>
												<model>
													<![CDATA[ ` + pricingtype + ` ]]>
												</model>
												<currency>
													<![CDATA[ USD ]]>
												</currency>
											</Pricing>
											` + impression + `
											<VASTAdTagURI>
												<![CDATA[ ` + strings.Replace(videoad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
																]]>
															</Tracking>
															<Tracking event="expand">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
																]]>
															</Tracking>
															<Tracking event="collapse">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
																]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		} else if videoad.Vast_type == 3 {
			if videoad.Vast_overlay_format.String == "image_overlay" {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<InLine>
											<AdSystem>
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											` + error_code + `
											<AdTitle>
												<![CDATA[ ` + videoad.Name + ` ]]>
											</AdTitle>
											` + adVerifications + `
											` + viewableImpression + `
											` + iabcategory + `
											<Pricing>
												<model>
													<![CDATA[ ` + pricingtype + ` ]]>
												</model>
												<currency>
													<![CDATA[ USD ]]>
												</currency>
											</Pricing>
											` + impression + `
											<Creatives>
												<Creative sequence="1">
													<UniversalAdId idRegistry="unknown" idValue="unknown">"unknown"</UniversalAdId>
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
																]]>
															</Tracking>
															<Tracking event="adExpand">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
																]]>
															</Tracking>
															<Tracking event="adCollapse">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
																]]>
															</Tracking>
															<Tracking event="acceptInvitation">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitation
																]]>
															</Tracking>
															<Tracking event="close">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=close
																]]>
															</Tracking>
															<Tracking event="overlayViewDuration">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=overlayViewDuration
																]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
																]]>
															</Tracking>
															<Tracking event="minimize">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=exitfullscreen
																]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `" conditionalAd="` + Is_conditionalad + `">
										<Wrapper fallbackOnNoAd="` + strconv.Itoa(videoad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(videoad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(videoad.Vast_wrapper_followadditional) + `">
											<AdSystem version="4.0">
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											` + error_code + `
											` + viewableImpression + `
											` + iabcategory + `
											<Pricing>
												<model>
													<![CDATA[ ` + pricingtype + ` ]]>
												</model>
												<currency>
													<![CDATA[ USD ]]>
												</currency>
											</Pricing>
											` + impression + `
											<VASTAdTagURI>
												<![CDATA[ ` + strings.Replace(videoad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
																]]>
															</Tracking>
															<Tracking event="adExpand">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
																]]>
															</Tracking>
															<Tracking event="adCollapse">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
																]]>
															</Tracking>
															<Tracking event="acceptInvitation">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitation
																]]>
															</Tracking>
															<Tracking event="close">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=close
																]]>
															</Tracking>
															<Tracking event="overlayViewDuration">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=overlayViewDuration
																]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
																]]>
															</Tracking>
															<Tracking event="minimize">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=exitfullscreen
																]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		} else {
			if videoad.Vast_overlay_format.String == "image_overlay" {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `">
										<InLine>
											<AdSystem>
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											` + error_code + `
											<AdTitle>
												<![CDATA[ ` + videoad.Name + ` ]]>
											</AdTitle>
											<AdServingId>` + adservingid + `</AdServingId>
											` + advertiser + `
											<Description>` + videoad.Name + `</Description>
											` + expiretime + `
											` + adVerifications + `
											` + viewableImpression + `
											` + iabcategory + `
											<Pricing>
												<model>
													<![CDATA[ ` + pricingtype + ` ]]>
												</model>
												<currency>
													<![CDATA[ USD ]]>
												</currency>
											</Pricing>
											` + impression + `
											<Creatives>
												<Creative sequence="1">
													<UniversalAdId idRegistry="unknown" idValue="unknown">"unknown"</UniversalAdId>
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
																]]>
															</Tracking>
															<Tracking event="adExpand">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
																]]>
															</Tracking>
															<Tracking event="adCollapse">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
																]]>
															</Tracking>
															<Tracking event="acceptInvitation">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitation
																]]>
															</Tracking>
															<Tracking event="close">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=close
																]]>
															</Tracking>
															<Tracking event="overlayViewDuration">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=overlayViewDuration
																]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
																]]>
															</Tracking>
															<Tracking event="minimize">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=exitfullscreen
																]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			} else {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `" conditionalAd="` + Is_conditionalad + `">
										<Wrapper fallbackOnNoAd="` + strconv.Itoa(videoad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(videoad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(videoad.Vast_wrapper_followadditional) + `">
											<AdSystem version="4.1">
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											<AdServingId>` + adservingid + `</AdServingId>
											` + advertiser + `
											<Description>` + videoad.Name + `</Description>
											` + expiretime + `
											` + error_code + `
											` + viewableImpression + `
											` + iabcategory + `
											<Pricing>
												<model>
													<![CDATA[ ` + pricingtype + ` ]]>
												</model>
												<currency>
													<![CDATA[ USD ]]>
												</currency>
											</Pricing>
											` + impression + `
											<VASTAdTagURI>
												<![CDATA[ ` + strings.Replace(videoad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
											</VASTAdTagURI>
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=creativeView
																]]>
															</Tracking>
															<Tracking event="adExpand">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=expand
																]]>
															</Tracking>
															<Tracking event="adCollapse">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=collapse
																]]>
															</Tracking>
															<Tracking event="acceptInvitation">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitation
																]]>
															</Tracking>
															<Tracking event="close">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=close
																]]>
															</Tracking>
															<Tracking event="overlayViewDuration">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=overlayViewDuration
																]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
																]]>
															</Tracking>
															<Tracking event="minimize">
																<![CDATA[
																	` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + bannerid + `&zoneid=0&event=exitfullscreen
																]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
												` + companionads + `
											</Creatives>
										</Wrapper>
									</Ad>
								</VAST>`
			}
		}
	}
	/*Inline & Overlay Ad XML Response*/
	return vastxml, vAttr
}
